/* (C) Brendan Macmillan 2003
	Free for commercial use only
*/

/* Note:
	JSX deals in "events", such as the start of an array, the end of an array,
	a primitive int value and so on.  When writing, each event is represented
	by a method call.  When reading, the next event is obtained by calling
	"next()", which returns an int which represents the event (see DataReaderI).
	The details of this event can be obtained from various "get" methods,
	(also in DataReaderI).

	The grammar of these events is the same as the "native" XML grammar
	for JSX.  Thus, you can see examples of the grammar just by looking at
	XML fragments generated by JSX; and the documentation of the XML grammar
	also documents the events.
*/

package JSX;
import java.io.Reader;
import java.io.IOException;

public interface DataReaderI {

		// IDEA: have constants in a separate
		// interface from the methods (ie next())

    // event types
		// FIXME: nicer if these were (also?) defined in user
		// of mapper
    public static int OPEN_GRAPH = 0;
    public static int CLOSE_GRAPH = 1;
    public static int OPEN_OBJECT = 2;
    public static int CLOSE_OBJECT = 3;
    public static int OPEN_DEFAULT = 4;
    public static int CLOSE_DEFAULT = 5;
    public static int OPEN_DECLARED_CLASS = 6;
    public static int CLOSE_DECLARED_CLASS = 7;
    public static int OPEN_ARRAY = 8;
    public static int CLOSE_ARRAY = 9;
    public static int PRIMITIVE = 10;
    public static int REFERENCE = 11;
    public static int NULL = 12;
    public static int RESET = 13; 	// bad luck!
    public static int STRING = 14; 
    public static int CLASS = 15; 
    public static int OPEN_COLLECTION = 16;
    public static int CLOSE_COLLECTION = 17;

		public static String[] token = {
			"OPEN_GRAPH",
			"CLOSE_GRAPH",
			"OPEN_OBJECT",
			"CLOSE_OBJECT",
			"OPEN_DEFAULT",
			"CLOSE_DEFAULT",
			"OPEN_DECLARED_CLASS",
			"CLOSE_DECLARED_CLASS",
			"OPEN_ARRAY",
			"CLOSE_ARRAY",
			"PRIMITIVE",
			"REFERENCE",
			"NULL",
			"RESET",
			"STRING",
			"CLASS",
			"OPEN_COLLECTION",
			"CLOSE_COLLECTION"
		};

		// this is only necessary if reading a stream... not for
		// a DB interface, for example...
    public void setReader(Reader reader) throws IOException;

    public String getDebugInfo();

/** move to next object event, return event type **/
    public int next() throws IOException;

/** java.io stream-based methods **/
		public boolean ready() throws IOException;
		public void close() throws IOException;


  public String getSuperclasses();
	public String getClassName();
	public String getFieldName();
	public String getFieldValue();
	public int getArrayLength();
	public String getAliasRef();
	public String getId();
  public int getArrayDim();
  public String getArrayBase();

}
